"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useExportAs_exports = {};
__export(useExportAs_exports, {
  useExportAs: () => useExportAs
});
module.exports = __toCommonJS(useExportAs_exports);
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_exportAs = require("../../utils/export/exportAs");
var import_toasts = require("../context/toasts");
var import_useTranslation = require("./useTranslation/useTranslation");
function useExportAs() {
  const editor = (0, import_editor.useEditor)();
  const { addToast } = (0, import_toasts.useToasts)();
  const msg = (0, import_useTranslation.useTranslation)();
  return (0, import_react.useCallback)(
    (ids, format = "png", name) => {
      (0, import_exportAs.exportAs)(editor, ids, format, name, {
        scale: 1,
        background: editor.getInstanceState().exportBackground
      }).catch((e) => {
        console.error(e.message);
        addToast({
          id: "export-fail",
          title: msg("toast.error.export-fail.title"),
          description: msg("toast.error.export-fail.desc"),
          severity: "error"
        });
      });
    },
    [editor, addToast, msg]
  );
}
//# sourceMappingURL=useExportAs.js.map
